/*
 * Decompiled with CFR 0.152.
 */
package com.pikachu.mod.illager_more.entities;

import com.pikachu.mod.illager_more.CombatEvent;
import com.pikachu.mod.illager_more.init.ModSounds;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class RedstoneGolemEntity
extends Raider
implements IAnimatable {
    private int attackTimer;
    private int mineAttackCooldown;
    private int attackID;
    public static final byte MELEE_ATTACK = 1;
    private static final EntityDataAccessor<Boolean> SUMMONING_MINES = SynchedEntityData.m_135353_(RedstoneGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_MELEE = SynchedEntityData.m_135353_(RedstoneGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    public int soundLoopTick;

    public RedstoneGolemEntity(EntityType<? extends Raider> type, Level worldIn) {
        super(type, worldIn);
        this.f_19793_ = 1.5f;
        this.f_21364_ = 40;
        this.mineAttackCooldown = 200;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SUMMONING_MINES, (Object)false);
        this.f_19804_.m_135372_(IS_MELEE, (Object)false);
    }

    public boolean isMeleeAttacking() {
        return (Boolean)this.f_19804_.m_135370_(IS_MELEE);
    }

    public void setMeleeAttacking(boolean attacking) {
        this.f_19804_.m_135381_(IS_MELEE, (Object)attacking);
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 2.0f, this::predicate));
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.REDSTONE_GOLEM_IDLE.get();
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_((SoundEvent)ModSounds.REDSTONE_GOLEM_STEP.get(), 1.0f, 1.0f);
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)ModSounds.REDSTONE_GOLEM_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.REDSTONE_GOLEM_DEATH.get();
    }

    private <P extends IAnimatable> PlayState predicate(AnimationEvent<P> event) {
        Vec3 velocity = this.m_20184_();
        float groundSpeed = Mth.m_14116_((float)((float)(velocity.f_82479_ * velocity.f_82479_ + velocity.f_82481_ * velocity.f_82481_)));
        if (this.isMeleeAttacking()) {
            event.getController().setAnimationSpeed(1.0);
            event.getController().setAnimation(new AnimationBuilder().addAnimation("attack", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
        } else if (!(event.getLimbSwingAmount() > -0.15f) || !(event.getLimbSwingAmount() < 0.15f)) {
            event.getController().setAnimationSpeed(Math.max((double)(groundSpeed * 10.0f), 0.1));
            event.getController().setAnimation(new AnimationBuilder().addAnimation(this.m_5912_() ? "run" : "walk", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else {
            event.getController().setAnimationSpeed(1.0);
            event.getController().setAnimation(new AnimationBuilder().addAnimation("idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        }
        return PlayState.CONTINUE;
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new DoHurtTargetGoal());
        this.f_21345_.m_25352_(5, (Goal)new AttackGoal((PathfinderMob)this, 1.3));
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, true));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    public void m_6075_() {
        super.m_6075_();
        if (this.f_20916_ > 0) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, -5.0, 0.0));
        }
    }

    public void m_8107_() {
        ++this.soundLoopTick;
        super.m_8107_();
        if (this.attackID != 0) {
            ++this.attackTimer;
        }
        if (!this.f_19853_.f_46443_ && this.mineAttackCooldown > 0) {
            --this.mineAttackCooldown;
        }
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 200.0).m_22268_(Attributes.f_22279_, 0.2825).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22281_, 18.0).m_22268_(Attributes.f_22282_, 2.85).m_22268_(Attributes.f_22277_, 32.0);
    }

    protected int m_7302_(int air) {
        return air;
    }

    public boolean m_7327_(Entity entityIn) {
        if (!this.f_19853_.f_46443_ && this.attackID == 0) {
            this.attackID = 1;
        }
        return true;
    }

    private void setAttackID(int id) {
        this.attackID = id;
        this.attackTimer = 0;
        this.f_19853_.m_7605_((Entity)this, (byte)(-id));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte id) {
        if (id <= 0) {
            this.attackID = Math.abs(id);
            this.attackTimer = 0;
        } else {
            super.m_7822_(id);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public Vec3 m_7939_() {
        return new Vec3(0.0, (double)(0.875f * this.m_20192_()), (double)(this.m_20205_() * 0.4f));
    }

    public SoundSource m_5720_() {
        return SoundSource.HOSTILE;
    }

    protected PathNavigation m_6037_(Level worldIn) {
        return new Navigator((Mob)this, worldIn);
    }

    public void m_7895_(int p_213660_1_, boolean p_213660_2_) {
    }

    public SoundEvent m_7930_() {
        return this.m_7515_();
    }

    public boolean m_7490_() {
        return false;
    }

    public boolean m_7307_(Entity entityIn) {
        if (super.m_7307_(entityIn)) {
            return true;
        }
        if (entityIn instanceof LivingEntity && ((LivingEntity)entityIn).m_6336_() == MobType.f_21643_ || entityIn instanceof Raider) {
            return this.m_5647_() == null && entityIn.m_5647_() == null;
        }
        return false;
    }

    class DoHurtTargetGoal
    extends Goal {
        private int delayCounter;
        private Vec3 vec3;

        public DoHurtTargetGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return RedstoneGolemEntity.this.m_5448_() != null && RedstoneGolemEntity.this.attackID == 1;
        }

        public boolean m_8045_() {
            return RedstoneGolemEntity.this.attackTimer <= 40;
        }

        public void m_8056_() {
            if (RedstoneGolemEntity.this.m_5448_() != null) {
                this.vec3 = RedstoneGolemEntity.this.m_5448_().m_20182_();
            }
            RedstoneGolemEntity.this.setAttackID(1);
            RedstoneGolemEntity.this.setMeleeAttacking(true);
        }

        public void m_8037_() {
            double moveSpeed = 1.0;
            if (RedstoneGolemEntity.this.m_5448_() != null && RedstoneGolemEntity.this.m_5448_().m_6084_()) {
                RedstoneGolemEntity.this.m_21563_().m_24960_((Entity)RedstoneGolemEntity.this.m_5448_(), 30.0f, 30.0f);
                RedstoneGolemEntity.this.m_7618_(EntityAnchorArgument.Anchor.EYES, RedstoneGolemEntity.this.m_5448_().m_20182_());
                if (RedstoneGolemEntity.this.attackTimer == 7) {
                    RedstoneGolemEntity.this.m_5496_((SoundEvent)ModSounds.REDSTONE_GOLEM_ATTACK.get(), 1.0f, 1.0f);
                }
                if (RedstoneGolemEntity.this.attackTimer == 8) {
                    CombatEvent.AreaAttack((LivingEntity)RedstoneGolemEntity.this, 5.0f, 5.0f, 5.0f, 5.0f, 170.0f, 1.0f, 0.1f, 0.5, false);
                }
                if (RedstoneGolemEntity.this.attackTimer >= 10) {
                    LivingEntity livingentity = RedstoneGolemEntity.this.m_5448_();
                    this.vec3 = RedstoneGolemEntity.this.m_5448_().m_20182_();
                    if (--this.delayCounter <= 0) {
                        this.delayCounter = 4 + RedstoneGolemEntity.this.m_217043_().m_188503_(7);
                        RedstoneGolemEntity.this.m_21573_().m_5624_((Entity)livingentity, moveSpeed);
                    }
                }
            } else if (RedstoneGolemEntity.this.attackTimer >= 10) {
                if (this.vec3 == null) {
                    this.vec3 = DefaultRandomPos.m_148403_((PathfinderMob)RedstoneGolemEntity.this, (int)10, (int)7);
                }
                if (--this.delayCounter <= 0) {
                    this.delayCounter = 4 + RedstoneGolemEntity.this.m_217043_().m_188503_(7);
                    if (this.vec3 != null) {
                        RedstoneGolemEntity.this.m_21573_().m_26519_(this.vec3.f_82479_, this.vec3.f_82480_, this.vec3.f_82481_, moveSpeed);
                    }
                }
            }
        }

        public void m_8041_() {
            RedstoneGolemEntity.this.setMeleeAttacking(false);
            RedstoneGolemEntity.this.setAttackID(0);
        }

        public boolean m_183429_() {
            return true;
        }
    }

    class AttackGoal
    extends MeleeAttackGoal {
        private final double moveSpeed;
        private int delayCounter;
        private int attackTimer;

        public AttackGoal(PathfinderMob creatureEntity, double moveSpeed) {
            super(creatureEntity, moveSpeed, true);
            this.moveSpeed = moveSpeed;
        }

        public boolean m_8036_() {
            return RedstoneGolemEntity.this.m_5448_() != null && RedstoneGolemEntity.this.m_5448_().m_6084_();
        }

        public void m_8056_() {
            RedstoneGolemEntity.this.m_21561_(true);
            this.delayCounter = 0;
        }

        public void m_8037_() {
            LivingEntity livingentity = RedstoneGolemEntity.this.m_5448_();
            if (livingentity == null) {
                return;
            }
            RedstoneGolemEntity.this.f_21365_.m_24960_((Entity)livingentity, 30.0f, 30.0f);
            if (--this.delayCounter <= 0) {
                this.delayCounter = 4 + RedstoneGolemEntity.this.m_217043_().m_188503_(7);
                RedstoneGolemEntity.this.m_21573_().m_5624_((Entity)livingentity, this.moveSpeed);
            }
            this.attackTimer = Math.max(this.attackTimer - 1, 0);
            this.m_6739_(livingentity, RedstoneGolemEntity.this.m_20275_(livingentity.m_20185_(), livingentity.m_20191_().f_82289_, livingentity.m_20189_()));
        }

        protected void m_6739_(LivingEntity enemy, double distToEnemySqr) {
            if ((distToEnemySqr <= this.m_6639_(enemy) || RedstoneGolemEntity.this.m_20191_().m_82381_(enemy.m_20191_())) && this.attackTimer <= 0) {
                int maxAttackTimer;
                this.attackTimer = maxAttackTimer = 0;
                RedstoneGolemEntity.this.m_7327_((Entity)enemy);
            }
        }

        public void m_8041_() {
            RedstoneGolemEntity.this.m_21573_().m_26573_();
            if (RedstoneGolemEntity.this.m_5448_() == null) {
                RedstoneGolemEntity.this.m_21561_(false);
            }
        }
    }

    static class Navigator
    extends GroundPathNavigation {
        public Navigator(Mob mobEntity, Level world) {
            super(mobEntity, world);
        }

        protected PathFinder m_5532_(int p_179679_1_) {
            this.f_26508_ = new Processor();
            return new PathFinder(this.f_26508_, p_179679_1_);
        }
    }

    static class Processor
    extends WalkNodeEvaluator {
        private Processor() {
        }

        protected BlockPathTypes m_6603_(BlockGetter blockReader, boolean canBreakDoors, boolean canWalkThroughDoorways, BlockPos blockPos, BlockPathTypes pathNodeType) {
            return pathNodeType == BlockPathTypes.LEAVES ? BlockPathTypes.OPEN : super.m_6603_(blockReader, canBreakDoors, canWalkThroughDoorways, blockPos, pathNodeType);
        }
    }
}

